this.name		= "Quantum Drive System";
this.author		= "Switeck";
this.licence		= "Creative Commons Attribution - Non-Commercial - Share Alike 3.0";
this.copyright	= "(C) 2023 Switeck";
this.description= "Galactic Hyperdrive destination changer.";
this.version		= "0.3.3 - for Oolite 1.80 and later";

"use strict";

this.activated = function()
{
	if(player.ship.equipmentStatus("EQ_QUANTUM_DRIVE") == "EQUIPMENT_OK" && player.ship.equipmentStatus("EQ_ADVANCED_NAVIGATIONAL_ARRAY") == "EQUIPMENT_OK") {
		if(player.ship.equipmentStatus("EQ_GAL_DRIVE") == "EQUIPMENT_OK") {
			if(missionVariables.quantumDrive > 3 || missionVariables.quantumDrive == null) missionVariables.quantumDrive = 0;
			missionVariables.quantumDrive++;
			if(missionVariables.quantumDrive == 1) {
				player.ship.galacticHyperspaceBehaviour = "BEHAVIOUR_STANDARD";
				player.commsMessage("Gal. Hyperdrive - Default mode, only reachable systems are possible destinations!",6);
			}
			if(missionVariables.quantumDrive == 2) {
				player.ship.galacticHyperspaceBehaviour = "BEHAVIOUR_ALL_SYSTEMS_REACHABLE";
				player.commsMessage("Gal. Hyperdrive - ALL systems Reachable!",6);
			}
			if(missionVariables.quantumDrive == 3) {
				player.ship.galacticHyperspaceBehaviour = "BEHAVIOUR_FIXED_COORDINATES";
				player.ship.galacticHyperspaceFixedCoords = [ 96, 96, 0];
				player.commsMessage("Gal. Hyperdrive - Go to Galaxy center (96, 96).",6);
			}
			if(missionVariables.quantumDrive == 4) {
				player.ship.galacticHyperspaceBehaviour = "BEHAVIOUR_FIXED_COORDINATES";
				player.ship.galacticHyperspaceFixedCoords = [ player.ship.cursorCoordinates.x, player.ship.cursorCoordinates.y, 0];
				player.commsMessage("Gal. Hyperdrive - Selected destination: "+player.ship.galacticHyperspaceFixedCoords,6);
			}
		} else player.commsMessage("Galactic Hyperdrive missing or damaged!",6);
	} else player.commsMessage("Quantum Drive damaged!",6);
}

this.mode = function ()
{
	if(player.ship.galacticHyperspaceBehaviour == "BEHAVIOUR_FIXED_COORDINATES") {
		player.commsMessage("Gal. Hyperdrive is set to Selected destination: "+player.ship.galacticHyperspaceFixedCoords,6);
	} else {
		if(player.ship.galacticHyperspaceBehaviour == "BEHAVIOUR_STANDARD") player.commsMessage("Gal. Hyperdrive mode is set to Default mode, only reachable systems are possible destinations.",6)
		else player.commsMessage("Gal. Hyperdrive mode is set to Extended mode, ALL systems Reachable!",6);
	}
}

this.playerEnteredNewGalaxy = function(galaxyNumber) 
{
	if(player.ship.equipmentStatus("EQ_ADVANCED_NAVIGATIONAL_ARRAY") != "EQUIPMENT_OK") {
		player.ship.galacticHyperspaceBehaviour = "BEHAVIOUR_FIXED_COORDINATES";
		player.ship.galacticHyperspaceFixedCoords = [ 96, 96, 0];
	} else if(player.ship.equipmentStatus("EQ_QUANTUM_DRIVE") == "EQUIPMENT_OK" && player.ship.galacticHyperspaceBehaviour != "BEHAVIOUR_STANDARD") {
		player.ship.galacticHyperspaceBehaviour = "BEHAVIOUR_STANDARD"; // restores to default
	}
	player.commsMessage("When repurchased, Gal. Hyperdrive will need to be reprogrammed by Quantum Drive before use!",15);
}
/*
this.playerEnteredNewGalaxy = function(galaxyNumber) 
{
	player.ship.galacticHyperspaceBehaviour = "BEHAVIOUR_STANDARD"; // restores to default
	player.commsMessage("Gal. Hyperdrive reset back to Default mode, only reachable systems are possible destinations!",15);
}

	if(player.ship.equipmentStatus("EQ_ADVANCED_NAVIGATIONAL_ARRAY") != "EQUIPMENT_OK") {
		player.ship.galacticHyperspaceBehaviour = "BEHAVIOUR_FIXED_COORDINATES";
		player.ship.galacticHyperspaceFixedCoords = [ 96, 96, 0];
		player.commsMessage("Gal. Hyperdrive - Go to Galaxy center (96, 96) due to missing or damaged Advanced Navigational Array.",6);
	} else if(player.ship.equipmentStatus("EQ_QUANTUM_DRIVE") == "EQUIPMENT_OK" && player.ship.galacticHyperspaceBehaviour != "BEHAVIOUR_STANDARD") {
		player.ship.galacticHyperspaceBehaviour = "BEHAVIOUR_STANDARD"; // restores to default
		player.commsMessage("Gal. Hyperdrive reset back to Default mode, only reachable systems are possible destinations!",15);
	} else player.commsMessage("Gal. Hyperdrive still in Default mode, no reprogramming actions taken!",15);

		player.commsMessage("When repurchased, Gal. Hyperdrive will be set to go to Galaxy center (96, 96) due to missing or damaged Advanced Navigational Array.",6);
	} else if(player.ship.equipmentStatus("EQ_QUANTUM_DRIVE") == "EQUIPMENT_OK" && player.ship.galacticHyperspaceBehaviour != "BEHAVIOUR_STANDARD") {
		player.ship.galacticHyperspaceBehaviour = "BEHAVIOUR_STANDARD"; // restores to default
		player.commsMessage("When repurchased, Gal. Hyperdrive will be reset back to Default mode, only reachable systems are possible destinations!",15);
	} else player.commsMessage("When repurchased, Gal. Hyperdrive will be still in Default mode, no reprograming actions taken!",15);
*/

this.playerStartedJumpCountdown = function (jump)
{
// Galatic MISJUMPS!
/*
				var swiDestX = Math.abs(System.infoForSystem(galaxyNumber,player.ship.targetSystem).internalCoordinates.x);
				var swiDestY = Math.abs(System.infoForSystem(galaxyNumber,player.ship.targetSystem).internalCoordinates.y);
				var curX = Math.abs(player.ship.galaxyCoordinates.x);
				var curY = Math.abs(player.ship.galaxyCoordinates.y);

	if(jump == "galactic") if(player.ship.scriptedMisjump == 1 || (player.ship.equipmentStatus("EQ_QUANTUM_DRIVE") == "EQUIPMENT_DAMAGED" && (player.ship.galacticHyperspaceBehaviour == "BEHAVIOUR_FIXED_COORDINATES" || player.ship.galacticHyperspaceBehaviour == "BEHAVIOUR_ALL_SYSTEMS_REACHABLE"))) {
	if(jump == "galactic" && (player.ship.scriptedMisjump == 1 || player.ship.equipmentStatus("EQ_QUANTUM_DRIVE") == "EQUIPMENT_DAMAGED") && player.ship.galacticHyperspaceBehaviour !== "BEHAVIOUR_STANDARD") {
	if(jump == "galactic" && (player.ship.scriptedMisjump == 1 || player.ship.equipmentStatus("EQ_QUANTUM_DRIVE") == "EQUIPMENT_DAMAGED")) {
*/
	if(jump == "galactic") if(player.ship.scriptedMisjump == 1 || (player.ship.equipmentStatus("EQ_QUANTUM_DRIVE") == "EQUIPMENT_DAMAGED" && player.ship.galacticHyperspaceBehaviour !== "BEHAVIOUR_STANDARD")) {
		if(galaxyNumber == 7 && system.ID ==162 && player.ship.galacticHyperspaceBehaviour !== "BEHAVIOUR_STANDARD") {
			var Xrand = Math.floor(245+Math.random()*6);
			var Yrand = Math.floor(200+Math.random()*56);
//			player.ship.targetSystem = 107;	// NEEDS to be done after Gal. Hyp. completes its jump.
		} else {
			var Xrand = Math.floor(Math.random()*256);
			var Yrand = Math.floor(Math.random()*256);
			if(player.ship.galacticHyperspaceBehaviour == "BEHAVIOUR_FIXED_COORDINATES") {
				var Xrand = Math.max(0,Math.min(255,Math.floor((Math.random()+Math.random())*10-10+Math.abs(System.infoForSystem(galaxyNumber,player.ship.targetSystem).internalCoordinates.x))));
				var Yrand = Math.max(0,Math.min(255,Math.floor((Math.random()+Math.random())*10-10+Math.abs(System.infoForSystem(galaxyNumber,player.ship.targetSystem).internalCoordinates.y))));
			} else if(player.ship.galacticHyperspaceBehaviour == "BEHAVIOUR_ALL_SYSTEMS_REACHABLE") {
				var Xrand = Math.max(0,Math.min(255,Math.floor((Math.random()+Math.random())*20-20+Math.abs(player.ship.galaxyCoordinates.x))));
				var Yrand = Math.max(0,Math.min(255,Math.floor((Math.random()+Math.random())*20-20+Math.abs(player.ship.galaxyCoordinates.y))));
			}
		}
		player.ship.galacticHyperspaceBehaviour = "BEHAVIOUR_FIXED_COORDINATES";
		player.ship.galacticHyperspaceFixedCoords = [ Xrand, Yrand, 0];
		player.commsMessage("Quantum Drive damaged or misconfigured -- unable to regulate Gal. Hyperdrive destination!",6);
		log(this.name,"Gal. Hyperdrive MISJUMP to random destination!: ",player.ship.galacticHyperspaceFixedCoords);
		player.ship.fireECM();	// For added effects and amusement!
//	} else if(player.ship.equipmentStatus("EQ_ADVANCED_NAVIGATIONAL_ARRAY") != "EQUIPMENT_OK" && player.ship.galacticHyperspaceBehaviour != "BEHAVIOUR_FIXED_COORDINATES") {
	} else if(player.ship.equipmentStatus("EQ_ADVANCED_NAVIGATIONAL_ARRAY") != "EQUIPMENT_OK") {
		player.ship.galacticHyperspaceBehaviour = "BEHAVIOUR_FIXED_COORDINATES";
		player.ship.galacticHyperspaceFixedCoords = [ 96, 96, 0];
		player.commsMessage("Gal. Hyperdrive - Go to Galaxy center (96, 96) due to missing or damaged Advanced Navigational Array.",6);
	}
}